IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_DELETE_PROCESSAMENTO_PENDENTE]'))
	DROP TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_DELETE_PROCESSAMENTO_PENDENTE]
GO
 
CREATE TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_DELETE_PROCESSAMENTO_PENDENTE] ON [dbo].[EST_PROD_REQ_TRANSF_LIB_ITENS] 
FOR DELETE
AS
UPDATE
	p
SET 
	p.DT_PROC=l.DT_CAD,
	p.DT_CAD=GETDATE()
FROM
	EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p INNER JOIN  DELETED d ON
	p.CD_EMP = d.CD_EMP AND
	p.CD_FILIAL = d.CD_FILIAL AND
	p.CD_PROD = d.CD_PROD
	INNER JOIN EST_PROD_REQ_TRANSF_LIB  l ON   
	d.CD_EMP = l.CD_EMP AND   
	d.CD_FILIAL = l.CD_FILIAL AND   
	d.CD_REQ = l.CD_REQ 
WHERE
	p.DT_PROC > l.DT_CAD;


INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
	(CD_EMP,
	CD_FILIAL,
	CD_PROD,
	DT_PROC,
	DT_CAD,
	DT_PROC_ATUAL)
SELECT DISTINCT 
	d.CD_EMP,
	d.CD_FILIAL,
	d.CD_PROD,
	MIN(l.DT_CAD),
	GETDATE(),
	NULL
FROM
	EST_PROD_REQ_TRANSF_LIB l INNER JOIN DELETED d ON   
	l.CD_EMP = d.CD_EMP AND   
	l.CD_FILIAL = d.CD_FILIAL AND   
	l.CD_REQ = d.CD_REQ 
	LEFT OUTER JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p ON
	p.CD_EMP = d.CD_EMP AND
	p.CD_FILIAL = d.CD_FILIAL AND
	p.CD_PROD = d.CD_PROD
WHERE
	p.CD_PROD IS NULL
GROUP BY
	d.CD_EMP,
	d.CD_FILIAL,
	d.CD_PROD;

--Deletando ultimo processamento de custo medio
DELETE
	p
FROM
	EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO p INNER JOIN DELETED d ON
	p.CD_EMP = d.CD_EMP AND
	p.CD_FILIAL = d.CD_FILIAL AND
	p.CD_PROD = d.CD_PROD;

GO


